/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.vo;

import javax.servlet.http.HttpServletRequest;

import jp.mosp.common.CommonConst;
import jp.mosp.common.vo.MosPVo;

public class ApprovalListVo extends MosPVo {

	private static final long serialVersionUID = -2182387767518501669L;

	// URLACSS
	private static final String RETURN_URL = "/jsp/kintai/approvalList.jsp";
	private static final String EXTRA_JS   = "/pub/kintai/js/approvalList.js";
	private static final String EXTRA_CSS  = "/pub/kintai/css/approvalList.css";

	// ʃTu^Cg
	public final String SUB_TITLE = CommonConst.TTL_APPROVAL_LIST;

	// 萔
	public static final int MODE_NOT_AUTH			= 0;
	public static final int MODE_1ST_APPROVAL		= 1;
	public static final int MODE_2ND_APPROVAL		= 2;

	// p[^
	public static final String PRM_PLT_YEAR  = "pltYear";
	public static final String PRM_PLT_MONTH = "pltMonth";

	public static final String PRM_CKB_DATE = "ckbSelectDate";

	// tB[hyѐ
	public static final String NAM_APPROVED	= CommonConst.NAM_APPROVED;

	// tB[h
	private String selectKCode;
	private String selectKName;
	private String selectSectionName;

	private String workTimes;
	private String breakTimes;
	private String lateTimes;
	private String leaveEarlyTimes;
	private String overTimes;
	private String workOnHoliday;
	private String lateNightTimes;

	private String presence;
	private String paidHoliday;
	private String particularHoliday;
	private String absence;
	private String sick;
	private String compensationLeave;
	private String transfer;
	private String other;

	private String leaveAndLate;
	private String allowance;

	private String[][] aryAttendance;
	private String[] aryLabel;

	private String pltYear;
	private String pltMonth;

	private String cmdListButton;
	private String namListButton;

	// FptB[h
	private String[] aryApprovalDate;

	// Tu^Cgj[R}h
	private String cmdMenuButton;

	// [h(1FꎟFA2F񎟏F)
	private int mode;

	// v_EXg
	public String[][] aryPltYear ;
	public String[][] aryPltMonth;

	/**
	 * RXgN^
	 */
	public ApprovalListVo() {
		super();
		setRetUrl(RETURN_URL);
		addExtraJs(EXTRA_JS);
		setExtraCss(EXTRA_CSS);
		pltYear  = "";
		pltMonth = "";
		aryAttendance 	= new String[0][0];
		aryLabel 		= new String[0];
		aryApprovalDate = new String[0];
		mode = MODE_NOT_AUTH;
	}

	/**
	 * p[^ݒ
	 * @param request NGXg
	 */
	public void setParams(HttpServletRequest request) {
		pltYear  = request.getParameter(PRM_PLT_YEAR );
		pltMonth = request.getParameter(PRM_PLT_MONTH);

		aryApprovalDate = request.getParameterValues(PRM_CKB_DATE);
	}

	/**
	 * tB[hݒ
	 * @param aryAttendance	Wvf[^Xg
	 * @param aryCompile	Wvf[^
	 * @param aryLabel		Wvx
	 */
	public void setFields(String[][] aryAttendance, String[] aryCompile, String[] aryLabel) {
		this.aryAttendance = escapeArray(aryAttendance.clone());
		this.aryLabel = escapeArray(aryLabel.clone());

		workTimes			= aryCompile[0];
		breakTimes			= aryCompile[1];
		lateTimes			= aryCompile[2];
		leaveEarlyTimes		= aryCompile[3];
		overTimes			= aryCompile[4];
		workOnHoliday		= aryCompile[5];
		lateNightTimes		= aryCompile[6];

		presence			= aryCompile[7];
		paidHoliday			= aryCompile[8];
		particularHoliday	= aryCompile[9];
		absence				= aryCompile[10];
		sick 				= aryCompile[11];
		compensationLeave	= aryCompile[12];
		transfer			= aryCompile[13];
		other				= aryCompile[14];

		leaveAndLate		= aryCompile[15];
		allowance			= aryCompile[16];

	}

	/**
	 * JavaScriptݒ
	 * @param cls 擾NX
	 * @throws IllegalAccessException
	 */
	@Override
	public String getDirectJs(Class cls) throws IllegalAccessException {
		StringBuffer sb = new StringBuffer();
		sb.append(super.getDirectJs(cls));
		sb.append("var MODE = ");
		sb.append(mode);
		sb.append(";");
		return sb.toString();
	}

	// ANZT\bh
	public String[][]	getEscAryAttendance	() { return aryAttendance.clone()	; }
	public String[]		getEscAryLabel		() { return aryLabel.clone()		; }

	public String[] getAryApprovalDate() { return aryApprovalDate.clone(); }

	public String getSelectKCode         () { return selectKCode                  ; }
	public String getSelectKName         () { return selectKName                  ; }
	public String getSelectSectionName   () { return selectSectionName            ; }
	public String getEscSelectKCode      () { return escapeHTML(selectKCode)      ; }
	public String getEscSelectKName      () { return escapeHTML(selectKName)      ; }
	public String getEscSelectSectionName() { return escapeHTML(selectSectionName); }

	public String getPltYear             () { return pltYear                      ; }
	public String getPltMonth            () { return pltMonth                     ; }
	public String getEscPltYear          () { return escapeHTML(pltYear)          ; }
	public String getEscPltMonth         () { return escapeHTML(pltMonth)         ; }

	public void setSelectKCode      (String selectKCode      ) { this.selectKCode       = selectKCode      ; }
	public void setSelectKName      (String selectKName      ) { this.selectKName       = selectKName      ; }
	public void setSelectSectionName(String selectSectionName) { this.selectSectionName = selectSectionName; }
	public void setPltYear          (String pltYear          ) { this.pltYear           = pltYear          ; }
	public void setPltMonth         (String pltMonth         ) { this.pltMonth          = pltMonth         ; }

	public void setCmdListButton(String cmdListButton) { this.cmdListButton = cmdListButton; }
	public void setNamListButton(String namListButton) { this.namListButton = namListButton; }
	public String getCmdListButton() {return cmdListButton; }
	public String getNamListButton() {return namListButton; }

	public String getEscWorkTimes		() { return escapeHTML(workTimes		); }
	public String getEscBreakTimes		() { return escapeHTML(breakTimes		); }
	public String getEscLateTimes		() { return escapeHTML(lateTimes		); }
	public String getEscLeaveEarlyTimes	() { return escapeHTML(leaveEarlyTimes	); }
	public String getEscOverTimes		() { return escapeHTML(overTimes		); }
	public String getEscWorkOnHoliday	() { return escapeHTML(workOnHoliday	); }
	public String getEscLateNightTimes	() { return escapeHTML(lateNightTimes	); }

	public String getEscPresence			() { return escapeHTML(presence				); }
	public String getEscPaidHoliday			() { return escapeHTML(paidHoliday			); }
	public String getEscParticularHoliday	() { return escapeHTML(particularHoliday	); }
	public String getEscAbsence				() { return escapeHTML(absence				); }
	public String getEscSick				() { return escapeHTML(sick					); }
	public String getEscCompensationLeave	() { return escapeHTML(compensationLeave	); }
	public String getEscTransfer			() { return escapeHTML(transfer				); }
	public String getEscOther				() { return escapeHTML(other				); }
	public String getEscLeaveAndLate		() { return escapeHTML(leaveAndLate			); }
	public String getEscAllowance			() { return escapeHTML(allowance			); }

	public String getCmdMenuButton() { return cmdMenuButton; }
	public void setCmdMenuButton(String cmdMenuButton) { this.cmdMenuButton = cmdMenuButton; }

	public void setMode(int mode) { this.mode = mode; }
	public int getMode() { return mode; }

}
